/** @file   Barrel.h
 * @brief   Declaration of Barrel class.
 * @version $Revision: 1.1.1.1 $
 * @date    $Date: 2006/01/21 23:02:41 $
 * @author  Tomi Lamminsaari
 */

#ifndef H_WWW_BARREL_H
#define H_WWW_BARREL_H

#include "gameobject.h"


namespace WeWantWar {

/** @class  Barrel
 * @brief   Represents a barrel.
 * @author  Tomi Lamminsaari
 *
 */
class Barrel : public GameObject
{
public:

  ///
  /// Constants, datatypes and static methods
  /// =======================================

  /** Possible types of the barrels.
   */
  enum BarrelType {
    /** Normal oil barrel. */
    EOil
  };

  /** Index of the timer that calculates the burning delay. */
  static const int BURN_TIMER_INDEX = 1;
  
  ///
  /// Constructors, destructor and operators
  /// ======================================

  /** Default constructor.
   * @param   aType             Type of the barrel.
   */
  Barrel( BarrelType aType );

  /** Destructor
   */
  virtual ~Barrel();

  /** Copy constructor
   * @param   aAnother          Reference to another Barrel
   */
  Barrel( const Barrel& aAnother );

  /** An assignment operator
   * @param   aAnother          Reference to another Barrel
   * @return  Reference to this object.
   */
  Barrel& operator= ( const Barrel& aAnother );


  ///
  /// Inherited methods
  /// =================

  /** From GameObject
   */
  virtual void update();
  
  /** From GameObject
   */
  virtual void redraw( RedrawQueue* aQueue );
  
  /** From GameObject
   */
  virtual void kill();
  
  /** From GameObject
   */
  virtual void makeSound( GameObject::SoundID aSoundId ) const;
  
  /** From GameObject
   */
  virtual bool hitByBullet( Bullet* aBullet );
  
  /** From GameObject
   * @return  ObjectID::TYPE_BARREL
   */
  virtual ObjectID::Type objectType() const;
  
  /** From GameObject
   * @return  Always false
   */
  virtual bool reloading() const;


  ///
  /// New public methods
  /// ==================


  ///
  /// Getter methods
  /// ==============


protected:
  ///
  /// Protected interface
  /// ===================

  /** Sets the correct animation.
   * @param   aAnimId           Id of the animation
   */
  virtual void setCorrectAnimation( int aAnimId );
  
  /** Generates the explosion
   */
  void createExplosion();

protected:
  ///
  /// Data members
  /// ============

  /** Type of this barrel. */
  BarrelType    iBarrelType;
  /** Uid of the flame animation. */
  int           iFlameAnimUid;
  /** Shadow offset position relative to barrel's position. */
  eng2d::Vec2D  iShadowOffsetPos;
};

};  // end of namespace

#endif
